{{-- resources/views/karyawan/partials/bottom-nav.blade.php --}}

{{-- <style>
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: white;
    display: flex;
    justify-content: space-around;
    align-items: center;
    padding: 8px 0;
    box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1);
    z-index: 1000;
    height: 60px;
}

.nav-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    color: #718096;
    font-size: 11px;
    font-weight: 600;
    transition: all 0.3s;
    padding: 8px 12px;
    border-radius: 8px;
    min-width: 60px;
}

.nav-item i {
    font-size: 20px;
    margin-bottom: 4px;
}

.nav-item.active {
    color: #4285f4;
}

.nav-item.active i {
    transform: scale(1.1);
}

.nav-item span {
    font-size: 10px;
}

@media (max-width: 480px) {
    .bottom-nav {
        height: 55px;
        padding: 6px 0;
    }

    .nav-item {
        min-width: 50px;
        padding: 6px 8px;
    }

    .nav-item i {
        font-size: 18px;
        margin-bottom: 3px;
    }

    .nav-item span {
        font-size: 9px;
    }
}
</style> --}}

<div class="bottom-nav">
    {{-- Beranda - Semua Role --}}
    <a href="{{ route('karyawan.dashboard') }}"
        class="nav-item {{ request()->routeIs('karyawan.dashboard') ? 'active' : '' }}">
        <i class="fas fa-home"></i>
        <span>Beranda</span>
    </a>

    {{-- Riwayat Absensi - Semua Role --}}
    <a href="{{ route('karyawan.absensi.log') }}"
        class="nav-item {{ request()->routeIs('karyawan.absensi.log') ? 'active' : '' }}">
        <i class="fas fa-history"></i>
        <span>Riwayat</span>
    </a>

    {{-- Pengajuan Cuti - Semua Role --}}
    <a href="{{ route('karyawan.pengajuan.index') }}"
        class="nav-item {{ request()->routeIs('karyawan.pengajuan.index') ? 'active' : '' }}">
        <i class="fas fa-calendar-alt"></i>
        <span>Pengajuan</span>
    </a>

    {{-- Approval atau Slip Gaji --}}
    @php
        $userRole = Auth::user()->role;
        // Role yang punya akses approval
        $canApprove = in_array($userRole, ['manager', 'gm', 'hrd', 'super_admin', 'admin']);
    @endphp

    @if($canApprove)
        {{-- Menu Approval untuk role admin --}}
        <a href="{{ route('admin.approval') }}"
            class="nav-item {{ request()->routeIs('admin.approval*') ? 'active' : '' }}">
            <i class="fas fa-check-circle"></i>
            <span>Approval</span>
        </a>
    @else
        {{-- Menu Slip Gaji untuk karyawan biasa --}}
        <a href="{{ route('karyawan.gaji.index') }}"
            class="nav-item {{ request()->routeIs('karyawan.gaji.index') ? 'active' : '' }}">
            <i class="fas fa-file-invoice-dollar"></i>
            <span>Slip Gaji</span>
        </a>
    @endif

    {{-- Pengaturan - Semua Role --}}
    <a href="{{ route('karyawan.settings.index') }}"
        class="nav-item {{ request()->routeIs('karyawan.settings.index') ? 'active' : '' }}">
        <i class="fas fa-cog"></i>
        <span>Pengaturan</span>
    </a>
</div>
